/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities.items;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import projectvibrantjourneys.init.object.PVJBlocks;
import projectvibrantjourneys.init.object.PVJEntities;
import projectvibrantjourneys.init.object.PVJItems;

public class PVJBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> PVJ_BOAT_TYPE = EntityDataManager.func_187226_a(PVJBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public PVJBoatEntity(EntityType<? extends PVJBoatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public PVJBoatEntity(World worldIn, double x, double y, double z) {
        this(PVJEntities.PVJ_BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PVJ_BOAT_TYPE, (Object)PVJBoatType.FIR.ordinal());
    }

    public Item func_184455_j() {
        switch (this.getCCBoatType()) {
            default: {
                return PVJItems.fir_boat;
            }
            case PINE: {
                return PVJItems.pine_boat;
            }
            case REDWOOD: {
                return PVJItems.redwood_boat;
            }
            case WILLOW: {
                return PVJItems.willow_boat;
            }
            case MANGROVE: {
                return PVJItems.mangrove_boat;
            }
            case PALM: {
                return PVJItems.palm_boat;
            }
            case ASPEN: {
                return PVJItems.aspen_boat;
            }
            case JUNIPER: {
                return PVJItems.juniper_boat;
            }
            case COTTONWOOD: {
                return PVJItems.cottonwood_boat;
            }
            case BAOBAB: {
                return PVJItems.baobab_boat;
            }
            case MAPLE: {
                return PVJItems.maple_boat;
            }
            case SAKURA: {
                return PVJItems.sakura_boat;
            }
            case TAMARACK: {
                return PVJItems.tamarack_boat;
            }
            case JOSHUA: 
        }
        return PVJItems.joshua_boat;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getCCBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setBoatType(PVJBoatType.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public void setBoatType(PVJBoatType boatType) {
        this.field_70180_af.func_187227_b(PVJ_BOAT_TYPE, (Object)boatType.ordinal());
    }

    public PVJBoatType getCCBoatType() {
        return PVJBoatType.byId((Integer)this.field_70180_af.func_187225_a(PVJ_BOAT_TYPE));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum PVJBoatType {
        FIR(PVJBlocks.fir_planks, "fir"),
        PINE(PVJBlocks.pine_planks, "pine"),
        REDWOOD(PVJBlocks.redwood_planks, "redwood"),
        WILLOW(PVJBlocks.willow_planks, "willow"),
        MANGROVE(PVJBlocks.mangrove_planks, "mangrove"),
        PALM(PVJBlocks.palm_planks, "palm"),
        ASPEN(PVJBlocks.aspen_planks, "aspen"),
        JUNIPER(PVJBlocks.juniper_planks, "juniper"),
        COTTONWOOD(PVJBlocks.cottonwood_planks, "cottonwood"),
        BAOBAB(PVJBlocks.baobab_planks, "baobab"),
        MAPLE(PVJBlocks.maple_planks, "maple"),
        SAKURA(PVJBlocks.sakura_planks, "sakura"),
        TAMARACK(PVJBlocks.tamarack_planks, "tamarack"),
        JOSHUA(PVJBlocks.joshua_planks, "joshua");

        private final String name;
        private final Block block;

        private PVJBoatType(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static PVJBoatType byId(int id) {
            PVJBoatType[] aboatentity$type = PVJBoatType.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static PVJBoatType getTypeFromString(String nameIn) {
            PVJBoatType[] aboatentity$type = PVJBoatType.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].getName().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }
}

